require('../config/config');


const { Sequelize, NUMBER } = require('sequelize');
const sequelize = new Sequelize(
    process.env.DB_NAME,
    process.env.USER,
    process.env.PASS, {
        host: process.env.HOST,
        dialect: process.env.DIALECT,
        pool: {
            max: Number(process.env.POOL_MAX),
            min: Number(process.env.POOL_MIN),
            acquire: Number(process.env.POOL_ACQUIRE),
            idle: Number(process.env.POOL_IDLE),
        },
        dialectOptions: {
            dateStrings: process.env.DIALECT_OPTS_DATESTRINGS,
            typeCast: process.env.DIALECT_OPTS_TYPECAST
        },
        timezone: process.env.TIMEZONE
    }
);

authDatabase = async() => {
    sequelize.authenticate()
        .then(() => console.log('Base de datos online!!!'))
        .catch(err => console.error('Hubo un error al conectar DB: ', err));
}

module.exports = {
    authDatabase: authDatabase(),
    sequelize,


};