/* jshint indent: 2 */
const { DataTypes } = require('sequelize');

const { sequelize } = require('../database/database');

const Categoria = sequelize.define('Categoria', {
    id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        primaryKey: true
    },
    nombre: {
        type: DataTypes.STRING(45),
        allowNull: false
    },
    clasificacion: {
        type: DataTypes.ENUM('N/A', 'A', 'B', 'C'),
        allowNull: false
    },
    aplica_para: {
        type: DataTypes.ENUM('J', 'C'),
        allowNull: false
    },
    edad_maxima: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true
    },
    edad_minima: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true
    },
    temporadas: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true
    },
    altura_maxima: {
        type: DataTypes.DECIMAL,
        allowNull: false,
        defaultValue: '0'
    },
    altura_minima: {
        type: DataTypes.DECIMAL,
        allowNull: false,
        defaultValue: '0'
    },
    estatus: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        defaultValue: '1'
    },
    disciplina_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        defaultValue: '1',
        references: {
            model: 'disciplinas',
            key: 'id'
        }
    },
    club_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true,
        references: {
            model: 'clubs',
            key: 'id'
        }
    },
    premiacion: {
        type: DataTypes.STRING(45),
        allowNull: true
    },
    fuera_concurso: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: '0'
    },
    created_at: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize.literal('CURRENT_TIMESTAMP')
    },
    updated_at: {
        type: DataTypes.DATE,
        allowNull: true
    }
}, {
    tableName: 'categorias',
    timestamps: false,
    underscored: true
});

module.exports = {
    Categoria
};