/* jshint indent: 2 */
const { DataTypes } = require('sequelize');

const { sequelize } = require('../database/database');



const Club = sequelize.define('Club', {
    id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        primaryKey: true
    },
    numero_registro: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        unique: true
    },
    referencia_bancaria: {
        type: DataTypes.STRING(12),
        allowNull: true,
        unique: true
    },
    correo_electronico: {
        type: DataTypes.STRING(60),
        allowNull: true
    },
    contrasenia: {
        type: DataTypes.STRING(191),
        allowNull: true
    },
    nombre: {
        type: DataTypes.STRING(80),
        allowNull: true
    },
    nombre_corto: {
        type: DataTypes.STRING(8),
        allowNull: true,
        unique: true
    },
    tipo: {
        type: DataTypes.ENUM('M', 'P'),
        allowNull: false,
        defaultValue: 'M'
    },
    rol: {
        type: DataTypes.INTEGER(1),
        allowNull: true,
        defaultValue: '1'
    },
    fecha_afiliacion: {
        type: DataTypes.DATEONLY,
        allowNull: true
    },
    estatus: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        defaultValue: '1'
    },
    calle: {
        type: DataTypes.STRING(60),
        allowNull: true
    },
    numero: {
        type: DataTypes.STRING(20),
        allowNull: true
    },
    colonia: {
        type: DataTypes.STRING(45),
        allowNull: true
    },
    delegacion: {
        type: DataTypes.STRING(45),
        allowNull: true
    },
    entidad_federativa_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true,
        references: {
            model: 'entidades_federativas',
            key: 'id'
        }
    },
    pais_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true,
        references: {
            model: 'paises',
            key: 'id'
        }
    },
    codigo_postal: {
        type: DataTypes.STRING(5),
        allowNull: true
    },
    presidente: {
        type: DataTypes.STRING(50),
        allowNull: true
    },
    representante: {
        type: DataTypes.STRING(60),
        allowNull: true
    },
    telefono: {
        type: DataTypes.STRING(30),
        allowNull: true
    },
    telefono2: {
        type: DataTypes.STRING(30),
        allowNull: true
    },
    fax: {
        type: DataTypes.STRING(30),
        allowNull: true
    },
    nombre_comite_organizador: {
        type: DataTypes.STRING(45),
        allowNull: true
    },
    rfc: {
        type: DataTypes.STRING(15),
        allowNull: true
    },
    logo: {
        type: DataTypes.STRING(191),
        allowNull: true
    },
    puntuacion: {
        type: DataTypes.INTEGER(1),
        allowNull: false,
        defaultValue: '1'
    },
    created_at: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize.literal('CURRENT_TIMESTAMP')
    },
    updated_at: {
        type: DataTypes.DATE,
        allowNull: true
    },
    ciudad: {
        type: DataTypes.STRING(45),
        allowNull: true
    },
    estado: {
        type: DataTypes.STRING(45),
        allowNull: true
    },
    direccion: {
        type: DataTypes.STRING(100),
        allowNull: true
    },
    coordenadas: {
        type: DataTypes.STRING(50),
        allowNull: true
    },
    logo_comite: {
        type: DataTypes.STRING(191),
        allowNull: true
    },
    password: {
        type: DataTypes.STRING(255),
        allowNull: true
    },
    credito_disponible: {
        type: DataTypes.DECIMAL,
        allowNull: false,
        defaultValue: '0.000'
    }
}, {
    tableName: 'clubs',
    timestamps: false,
    underscored: true
});

module.exports = {
    Club
};