/* jshint indent: 2 */
const { DataTypes } = require('sequelize');

const { sequelize } = require('../database/database');

const Competencia = sequelize.define('Competencia', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
    },
    pista_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    },
    concurso_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    },
    modalidad_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    },
    numero: {
        type: DataTypes.STRING(6),
        allowNull: false
    },
    fecha: {
        type: DataTypes.DATEONLY,
        allowNull: false
    },
    origen_id: {
        type: DataTypes.INTEGER(1),
        allowNull: true,
        defaultValue: '1'
    },
    current_round_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: '0'
    },
    is_finished: {
        type: DataTypes.INTEGER(1),
        allowNull: true
    },
    user_id: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    estatus_resultados: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: '0'
    },
    created_at: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize.literal('CURRENT_TIMESTAMP')
    },
    updated_at: {
        type: DataTypes.DATE,
        allowNull: true
    },
    finished_at: {
        type: DataTypes.DATE,
        allowNull: true
    },
    serie: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: '0'
    },
    final_serie: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: '0'
    },

}, {
    tableName: 'competencias',
    timestamps: false,
    underscored: true
});


module.exports = {
    Competencia

}