/* jshint indent: 2 */
const { DataTypes } = require('sequelize');

const { sequelize } = require('../database/database');

const EntidadFederativa = sequelize.define('entidades_federativas', {
    id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        primaryKey: true
    },
    nombre: {
        type: DataTypes.STRING(45),
        allowNull: false,
        unique: true
    },
    abreviatura: {
        type: DataTypes.STRING(5),
        allowNull: false
    },
    logo: {
        type: DataTypes.STRING(191),
        allowNull: true
    },
    created_at: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize.literal('CURRENT_TIMESTAMP')
    },
    updated_at: {
        type: DataTypes.DATE,
        allowNull: true
    }
}, {
    tableName: 'entidades_federativas',
    timestamps: false,
    underscored: true
});


module.exports = {
    EntidadFederativa

};