/* jshint indent: 2 */
const { DataTypes } = require('sequelize');

const { sequelize } = require('../database/database');

const ListasEntrada = sequelize.define('ListasEntrada', {
    id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        primaryKey: true
    },
    date: {
        type: DataTypes.DATE,
        allowNull: false
    },
    numero: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true
    },
    estatus: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        defaultValue: '1'
    },
    usuario_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        references: {
            model: 'usuarios',
            key: 'id'
        }
    },
    prueba_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        references: {
            model: 'pruebas',
            key: 'id'
        }
    },
    bloqueo: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        defaultValue: '1'
    },
    origen: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: '1'
    },
    created_at: {
        type: DataTypes.DATE,
        allowNull: true,
        defaultValue: sequelize.literal('CURRENT_TIMESTAMP')
    },
    updated_at: {
        type: DataTypes.DATE,
        allowNull: true
    },
    participantes: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    actualizacion_fei: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: '0'
    }
}, {
    tableName: 'listas_entrada',
    timestamps: false,
});

module.exports = {
    ListasEntrada
};