/* jshint indent: 2 */
const { DataTypes } = require('sequelize');

const { sequelize } = require('../database/database');

const Modalidad = sequelize.define('Modalidad', {
    id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        primaryKey: true
    },
    nombre: {
        type: DataTypes.STRING(100),
        allowNull: false,
        unique: true
    },
    baremo_id: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: '1'
    },
    display_totals: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: '0'
    }
}, {
    tableName: 'modalidades',
    underscored: true,
    timestamps: false
});
module.exports = {
    Modalidad
};