/* jshint indent: 2 */

const { DataTypes } = require('sequelize');

const { sequelize } = require('../database/database');

const Pais = sequelize.define('Pais', {
    id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        primaryKey: true
    },
    abreviatura: {
        type: DataTypes.STRING(8),
        allowNull: false,
        unique: true
    },
    abreviatura_ingles: {
        type: DataTypes.STRING(8),
        allowNull: true
    },
    nombre: {
        type: DataTypes.STRING(45),
        allowNull: false,
        defaultValue: '1',
        unique: true
    },
    estatus: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        defaultValue: '1'
    },
    bandera: {
        type: DataTypes.STRING(191),
        allowNull: true
    },
    nacionalidad: {
        type: DataTypes.STRING(45),
        allowNull: true
    },
    created_at: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize.literal('CURRENT_TIMESTAMP')
    },
    updated_at: {
        type: DataTypes.DATE,
        allowNull: true
    }
}, {
    tableName: 'paises',
    timestamps: false,
    underscored: true,
});

module.exports = {
    Pais
};