/* jshint indent: 2 */
const { DataTypes } = require('sequelize');

const { sequelize } = require('../database/database');

const Participante = sequelize.define('Participante', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
    },
    competition_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: 'competencias',
            key: 'id'
        }
    },
    persona_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        references: {
            model: 'personas',
            key: 'id'
        }
    },
    caballo_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        references: {
            model: 'caballos',
            key: 'id'
        }
    },
    categoria_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        references: {
            model: 'categorias',
            key: 'id'
        }
    },
    club_id: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    entidad_federativa_id: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    pais_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    },
    es_extemporaneo: {
        type: DataTypes.INTEGER(1),
        allowNull: false
    },
    cucarda: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    global_rank: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: '0'
    },
    category_rank: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: '0'
    },
    scored: {
        type: DataTypes.INTEGER(1),
        allowNull: true,
        defaultValue: '0'
    },
    created_at: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize.literal('CURRENT_TIMESTAMP')
    },
    updated_at: {
        type: DataTypes.DATE,
        allowNull: true
    },
    finish_time: {
        type: DataTypes.DECIMAL,
        allowNull: true,
        defaultValue: '0.00'
    },
    finish_faults: {
        type: DataTypes.DECIMAL,
        allowNull: true,
        defaultValue: '0.00'
    },
    clock_time: {
        type: DataTypes.DECIMAL,
        allowNull: true,
        defaultValue: '0.00'
    },
    es_del_juez: {
        type: DataTypes.INTEGER(1),
        allowNull: true,
        defaultValue: '0'
    },
    siacfem_id: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    serie_score: {
        type: DataTypes.DECIMAL,
        allowNull: true
    },
    jumpoff_rank: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    actual: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: '0'
    }
}, {
    tableName: 'participantes',
    timestamps: false,
    underscored: true
});



module.exports = {
    Participante
};