/* jshint indent: 2 */
const { DataTypes } = require('sequelize');

const { sequelize } = require('../database/database');
const Prueba = sequelize.define('Prueba', {
    id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        primaryKey: true
    },
    numero: {
        type: DataTypes.STRING(4),
        allowNull: false
    },
    tipo: {
        type: DataTypes.ENUM('N', 'I'),
        allowNull: false,
        defaultValue: 'N'
    },
    fecha: {
        type: DataTypes.DATE,
        allowNull: false
    },
    dia: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false
    },
    estatus: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        defaultValue: '1'
    },
    pista_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true,
        references: {
            model: 'pistas',
            key: 'id'
        }
    },
    modalidad_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true,
        references: {
            model: 'modalidades',
            key: 'id'
        }
    },
    concurso_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        references: {
            model: 'concursos',
            key: 'id'
        }
    },
    indice: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: '1'
    },
    nombre: {
        type: DataTypes.STRING(45),
        allowNull: true
    },
    nombre_ingles: {
        type: DataTypes.STRING(45),
        allowNull: true
    },
    puntuacion: {
        type: DataTypes.TEXT,
        allowNull: true
    },
    reparticion_premio: {
        type: DataTypes.TEXT,
        allowNull: true
    },
    oficial_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true,
        references: {
            model: 'oficiales',
            key: 'id'
        }
    },
    tipo_premio_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true,
        references: {
            model: 'desglose_tipo_premios',
            key: 'id'
        }
    },
    no_maximo_caballos: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    created_at: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize.literal('CURRENT_TIMESTAMP')
    },
    updated_at: {
        type: DataTypes.DATE,
        allowNull: true
    },
    tipo_puntuacion: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: '0'
    },
    orden: {
        type: DataTypes.DECIMAL,
        allowNull: true
    },
    url_video_live: {
        type: DataTypes.STRING(45),
        allowNull: true
    },
    fase: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: '0'
    },
    premiacion: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: '1'
    },
    premios_asignados: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: '0'
    },
    en_vivo: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: '0'
    }
}, {
    tableName: 'pruebas',
    timestamps: false,
});
module.exports = {
    Prueba
};