/* jshint indent: 2 */
const { DataTypes } = require('sequelize');

const { sequelize } = require('../database/database');

const Registro = sequelize.define('Registro', {
    id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        primaryKey: true
    },
    fecha: {
        type: DataTypes.DATE,
        allowNull: false
    },
    fecha_formato: {
        type: DataTypes.DATEONLY,
        allowNull: false
    },
    tipo: {
        type: DataTypes.ENUM('I', 'R'),
        allowNull: false
    },
    temporada: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false
    },
    estatus: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        defaultValue: '1'
    },
    club_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true,
        defaultValue: '1139',
        references: {
            model: 'clubs',
            key: 'id'
        }
    },
    persona_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true,
        references: {
            model: 'personas',
            key: 'id'
        }
    },
    caballo_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true,
        references: {
            model: 'caballos',
            key: 'id'
        }
    },
    created_at: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize.literal('CURRENT_TIMESTAMP')
    },
    updated_at: {
        type: DataTypes.DATE,
        allowNull: true
    },
    propietario_id: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    disciplina_id: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    medio_de_registro: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false
    },
    usuario_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true,
        references: {
            model: 'usuarios',
            key: 'id'
        }
    },
    comentarios: {
        type: DataTypes.STRING(100),
        allowNull: true
    },
    cambio_club: {
        type: DataTypes.STRING(200),
        allowNull: true
    },
    cambio_disciplina: {
        type: DataTypes.STRING(200),
        allowNull: true
    },
    fecha_identificacion: {
        type: DataTypes.DATEONLY,
        allowNull: true
    }
}, {
    tableName: 'registros',
    timestamps: false,
    underscored: true,
});


module.exports = {
    Registro
};