/* jshint indent: 2 */

module.exports = function(sequelize, DataTypes) {
  return sequelize.define('resultados_competencia', {
    id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    competition_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: 'competencias',
        key: 'id'
      }
    },
    competition_round_id: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    participant_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: 'participantes',
        key: 'id'
      }
    },
    time: {
      type: DataTypes.DECIMAL,
      allowNull: true
    },
    faults_by_obstacles: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: '0'
    },
    faults_by_time: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: '0'
    },
    total_faults: {
      type: DataTypes.DECIMAL,
      allowNull: true,
      defaultValue: '0.00'
    },
    time_extra: {
      type: DataTypes.FLOAT,
      allowNull: true,
      defaultValue: '0.00'
    },
    global_rank: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: '0'
    },
    category_rank: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: '0'
    },
    elimination_type_id: {
      type: DataTypes.INTEGER(1),
      allowNull: false,
      defaultValue: '0'
    },
    notes: {
      type: DataTypes.STRING(120),
      allowNull: true,
      defaultValue: ''
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal('CURRENT_TIMESTAMP')
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true
    },
    total_time: {
      type: DataTypes.DECIMAL,
      allowNull: true,
      defaultValue: '0.00'
    },
    clock_time: {
      type: DataTypes.DECIMAL,
      allowNull: true,
      defaultValue: '0.0000'
    },
    elimination_reason_id: {
      type: DataTypes.INTEGER(1),
      allowNull: true,
      defaultValue: '0'
    },
    article_round_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: '0'
    }
  }, {
    tableName: 'resultados_competencia'
  });
};
