/* jshint indent: 2 */
const { sequelize } = require('../database/database');
const { DataTypes } = require('sequelize');

const RoundsCompetencia = sequelize.define('RoundsCompetencia', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
    },
    competition_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    },
    article_round_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    },
    distance: {
        type: DataTypes.FLOAT,
        allowNull: false,
        defaultValue: '0.00'
    },
    cadence: {
        type: DataTypes.FLOAT,
        allowNull: false,
        defaultValue: '0.00'
    },
    obstacles_count: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: '0'
    },
    jumps_count: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: '0'
    },
    time_allowed: {
        type: DataTypes.DECIMAL,
        allowNull: true,
        defaultValue: '0.00'
    },
    time_limit: {
        type: DataTypes.DECIMAL,
        allowNull: true,
        defaultValue: '0.00'
    },
    created_at: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize.literal('CURRENT_TIMESTAMP')
    },
    updated_at: {
        type: DataTypes.DATE,
        allowNull: true
    },
    round_type: {
        type: DataTypes.INTEGER(1),
        allowNull: true
    },
    jueces_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    },
    on_jumpoff: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    participants_method: {
        type: DataTypes.INTEGER,
        allowNull: true
    }
}, {
    tableName: 'rounds_competencia',
    timestamps: false,
});

module.exports = {
    RoundsCompetencia
};