const express = require('express');
const app = express();
const Sequelize = require('sequelize');

const { Club } = require('../models/club');
const { Competencia } = require('../models/competencia');
const { Categoria } = require('../models/categoria');
const { EntidadFederativa } = require('../models/entidades_federativas');
const { ListasEntrada } = require('../models/listas_entrada');
const { Modalidad } = require('../models/modalidades');
const { Pais } = require('../models/pais');
const { Participante } = require('../models/participante');
const { Prueba } = require('../models/prueba');
const { Registro } = require('../models/registro');
const { RoundsCompetencia } = require('../models/rounds_competencia');
const { sequelize } = require('../database/database');
const path = require('path');


EntidadFederativa.hasMany(Club, { foreignKey: 'entidad_federativa_id', constraints: false });
Registro.belongsTo(Club, { as: "ClubRegistro", foreignKey: 'club_id' });
Competencia.hasMany(Participante, { as: 'CompetenciaParticipante', foreignKey: 'competition_id', constraints: false });
Competencia.belongsTo(Modalidad, { as: "CompetenciaModalidad", foreignKey: "modalidad_id" });

//sequelize.sync();

let ordenOE = (a, b) => {
    if (a.orden_entrada == null || b.orden_entrada == null) {
        return a.lugar_referencia > b.lugar_referencia;
    }
    return a.orden_entrada > b.lugar_referencia;
}
let ordenInverso = (a, b) => {
    if (a.orden_entrada == null || b.orden_entrada == null) {
        return a.lugar_referencia > b.lugar_referencia;
    }
    return a.orden_entrada < b.lugar_referencia;
}


let obtenerLugarLista = async(competencia, participante, res) => {
    let rawQuery = `SELECT IFNULL((SELECT position 
        FROM orden_participantes 
        WHERE participant_id = ${participante.id}
        AND competition_round_id = ${competencia.current_round_id}), 
       (SELECT position 
        FROM orden_participantes 
        WHERE participant_id = ${participante.id} LIMIT 1)) AS posicion`;
    let op = await sequelize.query(rawQuery, { type: sequelize.QueryTypes.SELECT })
        .then(posicion => posicion[0])
        .catch(err => res.status(500).json({
            error: true,
            message: err
        }));
    return op.posicion;

}

let origen = async(origen, tipo, persona, tabla, binomio, req, res) => {
    let club;
    let entidadFederativa;
    let pais;
    let registro;
    let imagesPath = path.resolve(__dirname, '../public/images')
    let completeLink = req.protocol + '://' + req.get('host');
    let tipoEliminacion;

    switch (origen) {
        case 2:
            if (tabla == 'participantes') {

                entidadFederativa = await EntidadFederativa.findOne({
                        where: {
                            id: binomio.entidad_federativa_id
                        },
                        attributes: ['id', 'abreviatura', [sequelize.fn('CONCAT', completeLink + '/images/escudos/', sequelize.col('logo')), 'imagen']]

                    })
                    .then(entidadfederativa => entidadfederativa)
                    .catch(err => res.status(500).json({
                        error: true,
                        message: err
                    }));
                return entidadFederativa;
            } else {

                entidadFederativa = await Registro.findOne({
                        where: {
                            caballo_id: null,
                            persona_id: persona.id,
                            estatus: 1
                        },
                        include: ["ClubRegistro"]


                    })
                    .then(async registro => {
                        return await EntidadFederativa.findOne({
                            where: {
                                id: registro.ClubRegistro.entidad_federativa_id
                            },
                            attributes: ['id', 'abreviatura', [sequelize.fn('CONCAT', completeLink + '/images/escudos/', sequelize.col('logo')), 'imagen']]
                        })
                    })
                    .catch(err => res.status(500).json({
                        error: true,
                        message: err
                    }));
                return entidadFederativa;
            }
            break;

        case 3:
            if (tabla == 'participantes') {
                pais = await Pais.findOne({
                        where: {
                            id: binomio.pais_id
                        },
                        attributes: ['id', 'abreviatura', [sequelize.fn('CONCAT', completeLink + '/images/banderas/', sequelize.col('bandera')), 'imagen']]

                    })
                    .then(pais => pais)
                    .catch(err => res.status(500).json({
                        error: true,
                        message: err
                    }));

            } else {
                if (tipo === 'N') {
                    pais = await Pais.findOne({
                            where: {
                                id: persona.pais_id,
                            },
                            attributes: ['id', 'abreviatura', [sequelize.fn('CONCAT', completeLink + '/images/banderas/', sequelize.col('bandera')), 'imagen']]

                        })
                        .then(pais => pais)
                        .catch(err => res.status(500).json({
                            error: true,
                            message: err
                        }));


                } else if (tipo === 'I') {
                    pais = await Pais.findOne({
                            where: {
                                id: persona.nacionalidad_deportiva_id,
                            },
                            attributes: ['id', 'abreviatura', [sequelize.fn('CONCAT', completeLink + '/images/banderas/', sequelize.col('bandera')), 'imagen']]

                        })
                        .then(pais => pais)
                        .catch(err => res.status(500).json({
                            error: true,
                            message: err
                        }));


                }
            }
            return pais;

            break;

        default:

            if (tabla == 'participantes') {
                //res.json(binomio);
                club = await Club.findOne({
                        where: {
                            id: binomio.club_id
                        },
                        attributes: ['id', ['nombre_corto', 'abreviatura'],
                            [sequelize.fn('CONCAT', completeLink + '/images/clubs/', sequelize.col('logo')), 'imagen']
                        ]

                    })
                    .then(club => {


                        return club;
                    })
                    .catch(err => res.status(500).json({
                        error: true,
                        message: err,
                        prueba: "prueba!!!"
                    }));

                return club;

            } else {
                club = await Registro.findOne({
                        where: {
                            caballo_id: null,
                            persona_id: persona.id,
                            estatus: 1
                        },
                        include: ["ClubRegistro"]


                    })
                    .then(registro => {
                        let clubs = {};
                        clubs.id = registro.ClubRegistro.id;

                        clubs.abreviatura = registro.ClubRegistro.nombre_corto;
                        clubs.imagen = (registro.ClubRegistro.logo != null) ? completeLink + '/images/clubs/' + registro.ClubRegistro.logo : null;
                        return clubs;
                    })
                    .catch(err => res.status(500).json({
                        error: true,
                        message: err
                    }));
                return club;
            }

            break;
    }
}

let agregarInformacionBinomio = async(prueba, lista, b, tabla = 'lista_entrada', req, res) => {

    let columnas_persona;
    let columnas_caballo;
    if (prueba.tipo == 'N') {
        columnas_persona = "id, nombre, apellido_paterno, apellido_materno, numero_registro, pais_id";
        columnas_caballo = "id, nombre, numero_registro, (SELECT nombre FROM colores WHERE colores.id = color_id) AS color, IF(sexo = 'Y', 'yegua', IF(sexo = 'C', IF(castrado = 'N', 'entero', IF(castrado = 'S', 'castrado', '-')),'-')) AS sexo, padre, (SELECT nombre FROM razas WHERE razas.id = raza_id) AS raza, DATE_FORMAT(fecha_nacimiento, '%Y') AS anio";
    } else if (prueba.tipo == 'I') {
        columnas_persona = "id, nombre_fei AS nombre, apellido_fei AS apellidos, numero_registro_fei AS numero_registro, nacionalidad_deportiva_id";
        columnas_caballo = "id, nombre_fei AS nombre, numero_pasaporte_fei AS numero_registro, (SELECT nombre FROM colores WHERE colores.id = fei_color_id) AS color, IF(fei_sexo = 'Y', 'yegua', IF(fei_sexo = 'C', IF(fei_castrado = 'N', 'entero', IF(fei_castrado = 'S', 'castrado', '-')),'-')) AS sexo, fei_padre AS padre, (SELECT IF(nombre_corto = '', NULL, nombre_corto) AS nombre_corto FROM studbooks WHERE studbooks.id = studbook_id) AS raza, DATE_FORMAT(fei_fecha_nacimiento, '%Y') AS anio";
    }

    let queryRaw = `SELECT ${columnas_persona} FROM personas WHERE id = ${b.persona_id}`;
    b.persona = await sequelize.query(queryRaw, { type: sequelize.QueryTypes.SELECT })
        .then(queryraw => queryraw[0])
        .catch(err => res.status(500).json({
            error: true,
            message: err
        }));




    queryRaw = `SELECT ${columnas_caballo} FROM caballos WHERE id = ${b.caballo_id}`;

    b.caballo = await sequelize.query(queryRaw, { type: sequelize.QueryTypes.SELECT })
        .then(queryraw => queryraw[0])
        .catch(err => res.status(500).json({
            error: true,
            message: err
        }));





    queryRaw = `SELECT id, IF(clasificacion = 'N/A', nombre, CONCAT(nombre, ' ', clasificacion)) AS nombre, fuera_concurso FROM categorias WHERE id = ${b.categoria_id}`;

    b.categoria = await sequelize.query(queryRaw, { type: sequelize.QueryTypes.SELECT })
        .then(queryraw => queryraw[0])
        .catch(err => res.status(500).json({
            error: true,
            message: err
        }));




    b.origen = await origen(lista.origen, prueba.tipo, b.persona, tabla, b, req, res)
        .then(res => res)
        .catch(err => res.status(500).json({
            error: true,
            message: err
        }));

    if (b.origen == null) {
        b.origen = {
            id: 1139,
            abreviatura: "SC",
            imagen: null,
        };
    }

    //res.json(b);
    if (prueba.tipo === 'N') {

        b.persona.nombre = b.persona.nombre.toLowerCase().replace(/\b[a-z]/g, (name) => name.toUpperCase()) + ' ' + b.persona.apellido_paterno.toUpperCase() + ' ' + b.persona.apellido_materno.toUpperCase()[0];

        delete b.persona.apellido_paterno;
        delete b.persona.apellido_materno;
        delete b.persona.pais_id;

    } else if (prueba.tipo === 'I') {
        if (b.persona.nombre != null) {
            b.persona.nombre = b.persona.nombre.toLowerCase().replace(/\b[a-z]/g, (name) => name.toUpperCase()) + ' ' + b.persona.apellidos.replace(/\b[a-z]/g, (name) => name.toUpperCase());
        } else {
            b.persona.nombre = " ";
        }
        // if (b.id == 53136) {
        //     res.json({});
        // }
        delete b.persona.apellidos;
        delete b.persona.nacionalidad_deportiva_id;




    }


}



app.get('/pruebas', async(req, res) => {
    await Prueba.findAll({
            where: {
                en_vivo: 1
            }
        })
        .then(pruebas => res.json(pruebas))
        .catch(err => console.error(err));


});
app.get('/prueba/:id/resultados', async(req, res) => {

    let countRounds;
    let generales = {};
    let columna_posicion;
    let sqlCalificados;
    let totales;
    let sqlPorCalificar;
    let arreglo_puntos;

    let id = req.params.id;

    await sequelize.query(`SET LC_TIME_NAMES = es_ES;`)
        .then()
        .catch(err => res.status(500).json({
            error: true,
            message: err
        }));

    let competencia = await Competencia.findOne({
            where: {
                id
            },
            include: ["CompetenciaParticipante", "CompetenciaModalidad"]
        })
        .then(competencia => competencia)
        .catch(err => res.status(500).json({
            error: true,
            message: err
        }));
    if (competencia == null) {
        return res.status(400).json({
            error: true,
            message: 'No se encontró información'
        });
    }

    let rounds = await RoundsCompetencia
        .findAndCountAll({
            where: {
                competition_id: id,
            }

        })
        .then(roundscompetencia => roundscompetencia)
        .catch(err => res.status(500).json({
            error: true,
            message: err
        }));


    if (rounds.count > 0) {
        countRounds = rounds.count;
        rounds = rounds.rows;
    }


    let rawQuery = `SELECT pruebas.id, pruebas.numero, pruebas.nombre, pruebas.tipo, (SELECT COUNT(*) FROM pruebas_categorias WHERE prueba_id = pruebas.id) AS no_categorias, modalidades.nombre AS modalidad, url_video_live, IF(DATE_FORMAT(fecha, '%H:%i') = '00:00', DATE_FORMAT(fecha, '%a %d %b, AT'), DATE_FORMAT(fecha, '%a %d %b, %H:%i %p')) AS fecha, (SELECT CONCAT(oficiales.nombre, ' ', oficiales.apellido_paterno, ' ', oficiales.apellido_materno) FROM oficiales WHERE oficiales.id = pruebas.oficial_id) AS diseniador, (SELECT nombre FROM pistas WHERE pistas.id = pruebas.pista_id) AS pista FROM pruebas, modalidades WHERE pruebas.id = ${id} AND pruebas.modalidad_id = modalidades.id`;
    let prueba = await sequelize.query(rawQuery, { type: sequelize.QueryTypes.SELECT })
        .then((rawQuery) => rawQuery[0])
        .catch(err => res.status(500).json({
            error: true,
            message: err
        }));

    prueba.numero = String("000" + prueba.numero).slice(-3);
    prueba.fecha = prueba.fecha.normalize("NFD").replace(/[\u0300-\u036f]/g, "");

    rawQuery = `SELECT oficiales.id, CONCAT(nombre, ' ', apellido_paterno, ' ', apellido_materno) AS nombre_completo FROM pruebas_oficiales, oficiales WHERE pruebas_oficiales.prueba_id = ${id} AND pruebas_oficiales.oficial_id = oficiales.id`;
    await sequelize.query(rawQuery, { type: sequelize.QueryTypes.SELECT })
        .then((rawQuery) => {
            prueba.jurado = rawQuery;
        })
        .catch(err => res.status(500).json({
            error: true,
            message: err
        }));

    rawQuery = `SELECT pruebas_categorias.categoria_id, IF(categorias.clasificacion = 'N/A', categorias.nombre, CONCAT(categorias.nombre, ' ', categorias.clasificacion)) AS nombre FROM pruebas_categorias, categorias WHERE pruebas_categorias.estatus = 1 AND categorias.id = pruebas_categorias.categoria_id AND prueba_id = ${prueba.id} ORDER BY categorias.fuera_concurso ASC`;
    await sequelize.query(rawQuery, { type: sequelize.QueryTypes.SELECT })
        .then((rawQuery) => {
            prueba.detalles = rawQuery;
        })
        .catch(err => res.status(500).json({
            error: true,
            message: err
        }));
    let lista = await ListasEntrada.findAll({
            where: {
                prueba_id: id,
                estatus: 1
            }
        })
        .then(listaentrada => listaentrada[0])
        .catch(err => res.status(500).json({
            error: true,
            message: err
        }));



    if (prueba.no_categorias > 1) {

        generales.nombre = "GENERALES";
        prueba.detalles.unshift(generales);
        columna_posicion = "category_rank";
        //prueba.detalles.unshift(generales);
    } else {
        columna_posicion = 'global_rank';
    }

    for (let l of prueba.detalles) {

        columna_posicion = (l.nombre == "GENERALES") ? 'global_rank' : 'category_rank';
        sqlCalificados = `SELECT id, persona_id, caballo_id, categoria_id, club_id, entidad_federativa_id, pais_id, ${columna_posicion} AS lugar, cucarda, ${columna_posicion} AS lugar_referencia, serie_score AS puntos, global_rank AS lugar_general FROM participantes WHERE competition_id = ${id} AND (SELECT COUNT(*) FROM resultados_competencia WHERE participantes.id = resultados_competencia.participant_id) > 0 `;

        if (l.categoria_id != null) {
            sqlCalificados += `AND categoria_id = ${l.categoria_id} `;
        }
        sqlCalificados += "ORDER BY global_rank";


        l.calificados = await sequelize.query(sqlCalificados, { type: sequelize.QueryTypes.SELECT })
            .then(sqlcalificados => sqlcalificados)
            .catch(err => res.status(500).json({
                error: true,
                message: err
            }));


        for (let b of l.calificados) {
            await agregarInformacionBinomio(prueba, lista, b, 'participantes', req, res)
                .catch(err => res.status(500).json({
                    error: true,
                    message: err
                }));


            rawQuery = `SELECT resultados_competencia.total_faults, resultados_competencia.total_time, resultados_competencia.elimination_type_id, article_rounds.name AS etiqueta FROM resultados_competencia, rounds_competencia, article_rounds WHERE resultados_competencia.participant_id = ${b.id} AND resultados_competencia.competition_round_id = rounds_competencia.id AND rounds_competencia.article_round_id = article_rounds.id ORDER BY competition_round_id`;
            b.resultados = await sequelize.query(rawQuery, { type: sequelize.QueryTypes.SELECT })
                .then(resultados => resultados)
                .catch(err => err);

            if (b.resultados.length < rounds.length || rounds.length == 1) {


                if (b.resultados[b.resultados.length - 1].elimination_type_id > 0) {
                    rawQuery = `SELECT abbr FROM elimination_types WHERE id = ${b.resultados[b.resultados.length - 1].elimination_type_id}`;
                    tipoEliminacion = await sequelize.query(rawQuery, { type: sequelize.QueryTypes.SELECT })
                        .then(tipoeliminacion => tipoeliminacion[0])
                        .catch(err => res.status(500).json({
                            error: true,
                            message: err
                        }));
                    b.lugar = tipoEliminacion.abbr;
                    b.resultados = [];


                } else if (competencia.modalidad_id == 3 && rounds[0].round_type != 1 && b.resultados[0].total_faults == 0) {
                    b.lugar = "DES";

                    b.orden_entrada = await obtenerLugarLista(competencia, b, res)
                        .then()
                        .catch(err => res.status(500).json({
                            error: true,
                            message: err
                        }));

                } else if (competencia.modalidad_id == 11) {

                    switch (rounds[1].participants_method) {
                        case 1:

                            onJumpoff = competencia.CompetenciaParticipante.length * rounds[1].on_jumpoff / 100;
                            onJumpoff = Math.round(onJumpoff);
                            if (onJumpoff >= b.lugar_general) {
                                b.orden_entrada = b.lugar;
                                b.lugar = "WR";
                            }
                            break;


                        case 2:
                            if (rounds[1].on_jumpoff >= b.lugar_general) {
                                b.orden_entrada = b.lugar;
                                b.lugar = "WR";
                            }
                            break;
                        case 3:
                            if (b.resultados[0].total_faults == 0) {
                                b.orden_entrada = b.lugar;
                                b.lugar = "WR";

                            }
                            break;
                    }

                }else if (competencia.modalidad_id == 10) {

                    switch (rounds[1].participants_method) {
                        case 1:

                            onJumpoff = competencia.CompetenciaParticipante.length * rounds[1].on_jumpoff / 100;
                            onJumpoff = Math.round(onJumpoff);
                            if (onJumpoff >= b.lugar_general) {
                                b.orden_entrada = b.lugar;
                                b.lugar = "DES";
                            }
                            break;


                        case 2:
                            if (rounds[1].on_jumpoff >= b.lugar_general) {
                                b.orden_entrada = b.lugar;
                                b.lugar = "DES";
                            }
                            break;
                        case 3:
                            let ceros = 0;
                            if (b.resultados[0].total_faults == 0) {
                                for(c of competencia.CompetenciaParticipante) {
                                    if(c.finish_faults == 0) {
                                        ceros += 1;
                                    }
                                }

                                if(ceros >= rounds[1].on_jumpoff) {
                                    onJumpoff = rounds[1].on_jumpoff;
                                }else if(ceros < rounds[1].on_jumpoff) {
                                    onJumpoff = ceros;
                                }
                                if (onJumpoff >= b.lugar_general) {
                                    b.orden_entrada = b.lugar;
                                    b.lugar = "DES";
                                }

                            }
                            break;
                    }

                }
            } else if (b.resultados.length == rounds.length) {

                if (b.resultados[b.resultados.length - 1].elimination_type_id > 0) {
                    rawQuery = `SELECT abbr FROM elimination_types WHERE id = ${b.resultados[b.resultados.length - 1].elimination_type_id}`;
                    tipoEliminacion = await sequelize.query(rawQuery, { type: sequelize.QueryTypes.SELECT })
                        .then(tipoeliminacion => tipoeliminacion[0])
                        .catch(err => res.status(500).json({
                            error: true,
                            message: err
                        }));
                    b.resultados[b.resultados.length - 1].total_faults = tipoEliminacion.abbr;
                    b.resultados[b.resultados.length - 1].total_time = null;
                    if (competencia.modalidad_id == 27) {
                        b.lugar = tipoEliminacion.abbr;
                    }
                } else if (competencia.CompetenciaModalidad.display_totals == 1) {

                    totales = {};
                    totales.etiqueta = "Total";
                    totales.elimination_type_id = 0;
                    totales.total_faults = Number(b.resultados[0].total_faults) + Number(b.resultados[1].total_faults);
                    if (competencia.modalidad_id == 5) {
                        totales.total_time = b.resultados[0].total_time;
                    } else if (competencia.modalidad_id == 25) {
                        totales.total_time = Math.abs(b.resultados[0].total_time - b.resultados[1].total_time);
                    } else if (competencia.modalidad_id == 27) {
                        totales.total_time = b.resultados[1].total_time;
                    }
                    totales.total_faults = Number(totales.total_faults).toFixed(2);
                    totales.total_time = Number(totales.total_time).toFixed(2);


                    b.resultados.push(totales);

                }

            }

            if (competencia.final_serie == 1) {
                arreglo_puntos = {};
                arreglo_puntos.total_faults = b.puntos;
                arreglo_puntos.total_time = "0";
                arreglo_puntos.elimination_type_id = 0;
                arreglo_puntos.etiqueta = "Puntos";
                b.resultados.unshift(arreglo_puntos);
            }

            let categoria = await Categoria.findByPk(b.categoria_id)
                .then(categoria => categoria)
                .catch(err => res.status(500).json({
                    error: true,
                    message: err
                }));
            if (categoria.fuera_concurso == 1) {
                b.lugar = "FC";
            }



            delete b.club_id;
            delete b.entidad_federativa_id;
            delete b.pais_id;
            delete b.puntos;
        }



        if (competencia.modalidad_id == 3) {
            l.calificados.sort((a, b) => ordenOE(a, b));

        } else if (competencia.modalidad_id == 11) {
            l.calificados.sort((a, b) => ordenInverso(a, b));
        }

        sqlPorCalificar = `SELECT participantes.id, 
        participantes.persona_id, 
        participantes.caballo_id, 
        participantes.categoria_id, 
        participantes.club_id,
        participantes.entidad_federativa_id,
        participantes.pais_id,
        IFNULL(orden_participantes.position, 1) AS posicion,
        participantes.cucarda,
        participantes.serie_score AS puntos
        FROM participantes 
        LEFT JOIN orden_participantes ON orden_participantes.participant_id = participantes.id
        WHERE participantes.competition_id = ${id} 
        AND (SELECT COUNT(*) 
        FROM resultados_competencia 
        WHERE participantes.id = resultados_competencia.participant_id) = 0 `;

        if (l.categoria_id != null) {
            sqlPorCalificar += `AND participantes.categoria_id = ${l.categoria_id} `;

        }

        sqlPorCalificar += "ORDER BY posicion";

        l.por_calificar = await sequelize.query(sqlPorCalificar, { type: sequelize.QueryTypes.SELECT })
            .then(sqlporcalificar => sqlporcalificar)
            .catch(err => res.status(500).json({
                error: true,
                message: err
            }));


        for (let b of l.por_calificar) {
            await agregarInformacionBinomio(prueba, lista, b, 'participantes', req, res)
                .catch(err => res.status(500).json({
                    error: true,
                    message: err,

                }));
            if (competencia.final_serie == 1) {
                arreglo_puntos = {};
                arreglo_puntos.total_faults = b.puntos;
                arreglo_puntos.total_time = "0";
                arreglo_puntos.elimination_type_id = 0;
                arreglo_puntos.etiqueta = "Puntos";
                b.resultados = [arreglo_puntos];



            }
            //res.json(l.por_calificar);
            delete b.club_id;
            delete b.entidad_federativa_id;
            delete b.pais_id;
            delete b.puntos;

        }
        // l.por_calificar.forEach(async b => {

        // });


    }


    rawQuery = `SELECT participantes.id, 
    participantes.persona_id, 
    participantes.caballo_id, 
    participantes.categoria_id, 
    participantes.club_id,
    participantes.entidad_federativa_id,
    participantes.pais_id,
    IFNULL(orden_participantes.position, 1) AS posicion,
    participantes.cucarda,
    participantes.serie_score AS puntos
    FROM participantes 
    LEFT JOIN orden_participantes ON orden_participantes.participant_id = participantes.id
    WHERE participantes.competition_id = ${id} 
    AND participantes.actual = 1`;

    prueba.en_calificacion = await sequelize.query(rawQuery, { type: sequelize.QueryTypes.SELECT })
        .then(encalificacion => encalificacion[0])
        .catch(err => res.status(500).json({
            error: true,
            message: err
        }));

    if (prueba.en_calificacion != null) {
        await agregarInformacionBinomio(prueba, lista, prueba.en_calificacion, 'participantes', req, res)
            .then(() => {}).catch(err => res.status(500).json({
                error: true,
                message: err
            }));

        if (competencia.final_serie == 1) {


            arreglo_puntos = {};
            arreglo_puntos.total_faults = prueba.en_calificacion.puntos;
            arreglo_puntos.total_time = "0";
            arreglo_puntos.elimination_type_id = 0;
            arreglo_puntos.etiqueta = "Puntos";
            prueba.en_calificacion.resultados = [arreglo_puntos];

        }

        delete prueba.en_calificacion.club_id;
        delete prueba.en_calificacion.entidad_federativa_id;
        delete prueba.en_calificacion.pais_id;
        delete prueba.en_calificacion.puntos;

    } else {
        prueba.en_calificacion = null;
    }

    res.json(prueba);


});




module.exports = app;